string GetDescription()
{
	return "Creates a simple punk rock style drum sequence";
}

void DoSnare(RenderPart @p)
{
	double step = 1.0;
	
	if (p.GetTempo() < 70) step /= 2.0;
	
	double len = p.GetUniquePart().GetMetrum() / step;
	
	int pat_len = RndInt(1,2) * len;
	
	int[] pattern(pat_len);
	
	for (int i = 0; i < pat_len; i++)
		pattern[i] = RndInt(0,2);	
	
	int n = 0;
		
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=step)
		{		
			p.AddPercNote(CreateTime(i,m), CreateTime(i,m+0.1), 40, 127);
			
			int doit = pattern[n%pat_len];
			if (RndInt(0,2) == 0) doit = RndInt(0,2);
			
			if (doit == 0 || doit == 1) p.AddPercNote(CreateTime(i,m+step*5.0/8.0), CreateTime(i,m+0.1+step*5.0/8.0), 38, RndInt(90,100));
			
			if (doit == 1) p.AddPercNote(CreateTime(i,m+step*2.5/8.0), CreateTime(i,m+0.1+step*2.5/8.0), 40, RndInt(80,100));
			
			if (doit == 2)
			{
				p.AddPercNote(CreateTime(i,m+step*4.0/6.0), CreateTime(i,m+0.1+step*4.0/6.0), 40, RndInt(80,90));
				p.AddPercNote(CreateTime(i,m+step*5.0/6.0), CreateTime(i,m+0.1+step*5.0/6.0), 38, RndInt(90,100));
			}
			
			n++;
		}
	}
}

void DoFoot(RenderPart @p)
{
	double step = 1.0;
	if (p.GetTempo() < 70) step /= 2.0;
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=step)
			p.AddPercNote(CreateTime(i,m), CreateTime(i,m+0.1), 36, RndInt(75,95));
		if (RndInt(0,1) == 0) p.AddPercNote(CreateTime(i,p.GetUniquePart().GetMetrum()- step*0.25), CreateTime(i,p.GetUniquePart().GetMetrum() - step*0.1), 36, RndInt(65,85));
	}
}

void DoCymbal(RenderPart @p)
{
	double step = 1.0;
	if (p.GetTempo() < 70) step /= 2.0;
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		int n = 0;
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=step)
		{
			if (n == 0 || (n == 1 && RndInt(0,1) == 0)) p.AddPercNote(CreateTime(i,m), CreateTime(i,m+0.1), 59, RndInt(85,115));
			if (n == 0) n = 1; else n = 0;
		}
	}
}


void Render(RenderPart @p)
{
	if (p.GetParam("snare").toInt() > 0) DoSnare(p);
	if (p.GetParam("foot").toInt() > 0) DoFoot(p);
	if (p.GetParam("cymbal").toInt() > 0) DoCymbal(p);
	
}